package de.renew.unify;

/**
 * This exception is thrown to indicate that the unification cannot be completed
 * with the current values. Therefore, backtracking needs to be started.
 */
public class Impossible extends Exception {

    /**
     * Default constructor for the Impossible class.
     * This constructor initializes the exception with no message.
     */
    public Impossible() {}

    /**
     * Constructor for the Impossible class with a given message.
     *
     * @param msg the message to be associated with the exception
     */
    public Impossible(String msg) {
        super(msg);
    }

    /**
     * Constructor for the Impossible class with a given cause.
     *
     * @param cause the cause of the exception
     */
    public Impossible(Throwable cause) {
        super(cause);
    }

    /**
     * Constructor for the Impossible class with a given message and cause.
     *
     * @param msg the message to be associated with the exception
     * @param cause the cause of the exception
     */
    public Impossible(String msg, Throwable cause) {
        super(msg, cause);
    }

    /**
     * Throws an Impossible exception.
     * This method is used to indicate that an operation cannot be completed
     * due to an impossible state.
     *
     * @throws Impossible is always thrown
     */
    @Deprecated
    public static void THROW() throws Impossible {
        throw new Impossible();
    }

}