package de.renew.net.inscription;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.NetInstance;


class EarlyConfirmer implements EarlyExecutable {
    NetInstance netInstance;

    EarlyConfirmer(NetInstance netInstance) {
        this.netInstance = netInstance;
    }

    @Override
    public long lockPriority() {
        return 0;
    }

    @Override
    public void lock() {
        // Nothing to do.
    }

    @Override
    public int phase() {
        return EARLYCONFIRM;
    }

    // This will not take long.
    public boolean isLong() {
        return false;
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) {
        netInstance.earlyConfirmation();
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        netInstance.earlyConfirmationTrace(stepIdentifier);
    }

    @Override
    public void rollback() {
        // Nothing to do.
    }

    @Override
    public void unlock() {
        // Nothing to do.
    }
}