package de.renew.net.event;

/**
 * A standard implementation of the PlaceEventListener interface.
 */
public class PlaceEventAdapter implements PlaceEventListener {
    boolean wantSync;

    /**
     * Constructs a new PlaceEventAdapter with the given wantSync value.
     *
     * @param wantSync true if the notifications should be done synchronously, false if they are done asynchronously
     */
    public PlaceEventAdapter(boolean wantSync) {
        this.wantSync = wantSync;
    }

    @Override
    public boolean wantSynchronousNotification() {
        return wantSync;
    }

    @Override
    public void markingChanged(PlaceEvent pe) {}

    @Override
    public void tokenAdded(TokenEvent te) {}

    @Override
    public void tokenRemoved(TokenEvent te) {}

    @Override
    public void tokenTested(TokenEvent te) {}

    @Override
    public void tokenUntested(TokenEvent te) {}
}