package de.renew.net;

import java.util.Iterator;

import de.renew.engine.simulator.SimulationThreadPool;


/**
 * A class containing some helper methods that don't appear to be used.
 */
public class EventHelper {
    /**
     * Finds a place by its name in a {@link Net}.
     *
     * @param net the net to look for the place in
     * @param name the name of the place that should be returned
     * @return the place with that name, or null if no place with that name has been found
     */
    public static Place getNamedPlace(Net net, String name) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        synchronized (net) {
            Iterator<Place> enumeration = net.places().iterator();
            while (enumeration.hasNext()) {
                Place place = enumeration.next();

                // Using the toString() method is ugly.
                // Maybe create a getName() method?
                if (name.equals(place.getName())) {
                    return place;
                }
            }
            return null;
        }
    }

    /**
     * Deposits a token in a place identified by its name (in a {@link NetInstance}).
     *
     * @param ni the net instance that the place is located in
     * @param name the name of the place to deposit the token in
     * @param token the token to deposit
     */
    public static void deposit(NetInstance ni, String name, Object token) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        Place place = getNamedPlace(ni.getNet(), name);
        if (place == null) {
            throw new RuntimeException("No such place.");
        }
        SimulatablePlaceInstance pi = (SimulatablePlaceInstance) ni.getInstance(place);
        pi.lock.lock();
        try {
            pi.insertToken(token, 0);
        } finally {
            pi.lock.unlock();
        }
    }
}