package de.renew.engine.simulator;

import java.util.Comparator;

import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.LateExecutable;


/**
 * This comparator can be used to order {@link Executable}
 * instances in a {@link java.util.SortedSet} or similar classes
 * by their phase.
 *
 * @see EarlyExecutable#phase()
 * @see LateExecutable#phase()
 * @author Olaf Kummer
 * @author Michael Duvigneau (added documentation)
 **/
public class PhaseComparator implements Comparator<Executable> {

    /**
     * {@inheritDoc}
     * @param first  the first Executable to compare
     * @param second  the second Executable to compare
     * @return -1 if <code>first</code> should be executed first (has a lower
     *            {@link Executable#phase()} value). <br />
     *         +1 if <code>second</code> should be executed first.
     *         0  if both share the same {@link Executable#phase()}
     *            value
    * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
    **/
    @Override
    public int compare(Executable first, Executable second) {
        return Integer.compare(first.phase(), second.phase());
    }
}