package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;


public class AbstractConcurrentChildSimulator extends AbstractConcurrentSimulator {
    private final Simulator _parentSimulator;

    public AbstractConcurrentChildSimulator(
        boolean wantEventQueueDelay, boolean wantConcurrentExecution, Simulator parentSimulator)
    {
        super(wantEventQueueDelay, wantConcurrentExecution);
        _parentSimulator = parentSimulator;
    }

    public Simulator getParentSimulator() {
        return _parentSimulator;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        return getParentSimulator().nextStepIdentifier();
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        return getParentSimulator().currentStepIdentifier();
    }
}