package de.renew.database.entitylayer;

import java.sql.SQLException;


/**
 * This class extends SQLException and is an exception for a missing entity in the database.
 */
public class NoSuchEntityException extends SQLException {
    /**
     * Parameterless constructor for the NoSuchEntityException,
     * which calls the SQLException's constructor.
     */
    public NoSuchEntityException() {
        super();
    }

    /**
     * Constructor with String parameter for the message,
     * which calls the SQLException's constructor with the String parameter as parameter.
     * @param message the message, which is displayed alongside the exception
     */
    public NoSuchEntityException(String message) {
        super(message);
    }
}