<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Simulator

## User Guide

The Renew _Simulator_ component comprises the simulation engine, its
database connectivity and the interfaces/classes needed to feed
and watch the simulation.

### Features

- Adds the Simulation Engine
- Adds the Database connectivity
- Adds the Interfaces and Classes to feed and watch the simulation

### Example Usage

1. Open a net of type Java reference net in the graphical editor.
2. Start the simulation via Simulation -> Run simulation or with Ctrl-R.
3. Watch the simulation.
4. Terminate the simulation via Simulation -> Terminate simulation or with Ctrl-T.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- `de.renew.application.StartSimulationCommand`	- starts a simulation
- `de.renew.application.SimulationControlCommand`	- controls the simulation

### Installation

Install _Simulator_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Util`: basic classes like HashMap, Iterator etc.
- `java.sql`: stores net instance, place instance, token and token position state in an SQL Database
- `log4j`: Logging framework

### Configuration

During the initialization of _Simulator_, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.simulatorMode`|`int`|Specifies simulator class and multiplicity to use. *|1
`de.renew.eagerSimulation`|`boolean`|Specifies whether the simulator should use eager simulation.|false
`de.renew.netPath`|`path`|Specifies the search path of net loaders (like the Java CLASSPATH). If not set, the current directory is used.|not set
`de.renew.classReinit`|`boolean`|Specifies whether custom classes (those known by the property de.renew.classPath) should be reloaded on each simulation run.|false
`de.renew.remote.enable`|`boolean`|Controls whether the remote access to local simulations should be allowed or not.|false
`de.renew.remote.publicName`|`String`|Specifies the name part of the URL under which the remote server will be announced at the RMI registry.|default
`de.renew.remote.serverClass`|`Class`|Specifies the de.renew.remote.Server implementation to use.|de.renew.remote.ServerImpl|de.renew.remote.ServerImpl
`de.renew.remote.socketFactory`|`Class`|Specifies the java.rmi.server.RMISocketFactory implementation to use. If not set, the default RMI socket factory is used.|not set
`de.renew.simdb.driver`|`Class`|This property is mandatory to enable database support. There are no type restrictions on the class.|not set
`de.renew.simdb.url`|`URL`|This property is mandatory to enable database support.|not set
`de.renew.simdb.dialect`|`Class`|The named class must be a subclass of de.renew.database.entitylayer.SQLDialect.|de.renew.database.entitylayer.SQLDialect
`de.renew.simdb.user`|`String`|The user account to use for database login. If not set, the database is used without an user account.|not set
`de.renew.simdb.password`|`String`|The password for the user login. If the property de.renew.simdb.user is not set, this property is ignored.|not set
\* Possible values:
- Negative values: Use multiple sequential simulators. The absolute value determines the number of simulators.
- 0: Same as -1: Use one sequential simulator.
- 1 (default): Use one concurrent simulator.
- Positive values: Use multiple concurrent simulators. The absolute value determines the number of simulators.

## Developer Guide

### Core Classes

- `SimulatorPlugin`: Implements the main facade for the Renew _Simulator_ component.
- `DatabaseRestoreSource`: extract the current information about a system of nets out of a persistent store.
- `SimulationControlCommand`: provides several subcommand to control the simulation engine. This includes single-step mode and consecutive runs as well as simulation termination.

### How to Extend

_Simulator_ exposes multiple Interfaces,
- `de.renew.application.SimulatorPlugin` (and related classes, especially SimulatorExtension and SimulationEnvironment)
- `de.renew.engine.simulator.Simulator`
- `de.renew.engine.searcher.TracerFactory` (and related classes)
- `de.renew.remote.Server` (and related classes, including all Accessor interfaces)
- `de.renew.remote.ShadowNetSystem` (and related classes)
- `de.renew.remote.RemoteServerRegistry` (and related classes)
You can implement these interfaces to add additional functionality to the Plugin.

<!--### Additional Information -->

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->

<!-- License -->

