package de.renew.netcomponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;

/**
 * This is a test class for {@link RemoveToolsControl}.
 */
@ExtendWith(MockitoExtension.class)
public class RemoveToolsControlTest {

    private RemoveToolsControl _testControl;
    private Vector<ComponentsTool> _testV;
    @Mock
    private ComponentsTool _testCompTool1;
    @Mock
    private ComponentsTool _testCompTool2;
    @Mock
    private ComponentsToolPlugin _componentsToolPluginTest;

    /**
     * Creates an object of {@link RemoveToolsControl} and its intern vector v.
     */
    @BeforeEach
    public void setUp() {
        _testCompTool1 = mock(ComponentsTool.class);
        _testCompTool2 = mock(ComponentsTool.class);
        _componentsToolPluginTest = mock(ComponentsToolPlugin.class);

        _testV = new Vector<>();
        _testV.add(_testCompTool1);
        _testV.add(_testCompTool2);
        doReturn(_testV).when(_componentsToolPluginTest).getCTList();

        //testControl sets v to the CTList of its ComponentsToolPlugin, thus testV
        RemoveToolsControl testControl1 = new RemoveToolsControl(_componentsToolPluginTest);
        _testControl = spy(testControl1);
    }

    /**
     * Tests if {@link RemoveToolsControl#getV()} returns the right vector.
     */
    @Test
    public void getVTest() {
        assertEquals(_testV, _testControl.getV());

        Vector<ComponentsTool> testComponents = new Vector<>();
        testComponents.add(mock(ComponentsTool.class));
        testComponents.add(mock(ComponentsTool.class));

        _testControl.update(testComponents);
        assertEquals(testComponents, _testControl.getV());
        assertNotEquals(_testV, _testControl.getV());
    }

    /**
     * Tests the method from {@link RemoveToolsControl#removeFromList(List)}.
     * The class contains a vector from which a list of {@link ComponentsTool} is removed.
     */
    @Test
    public void testRemoveFromList() {
        // in the beginning the list should be as initialized
        assertEquals(_testV, _testControl.getV());
        assertEquals(2, _testControl.getV().size());

        // when the list contains an element of the intern list it should be removed
        List<ComponentsTool> testList = new ArrayList<>();
        testList.add(_testCompTool1);
        _testControl.removeFromList(testList);
        assertFalse(_testControl.getV().contains(_testCompTool1));
        assertTrue(_testControl.getV().contains(_testCompTool2));
        assertEquals(1, _testControl.getV().size());
    }

}