package de.renew.netcomponents;

import java.util.Vector;

import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Command;
import de.renew.plugin.command.CLCommand;


/**
 * @author cabac
 *
 */
public interface ComponentsPluginExtender {
    /**
     * Returns a list of Commands - made available by the plugin - that
     * can be added to the Menu of the plugee.
     *
     * @return A list of commands that can be added to the Menu of the plugee
     */
    Vector<Command> getMenuCommands();

    /**
     * Returns  Prompt (Command Line) Commands that offer functionality of
     * the plugin to the plugee. The plugee can offer this functionality to
     * the user on the prompt.
     *
     * @return Prompt Commands that offer functionality of the plugin to the plugee.
     */
    Vector<CLCommand> getPromptCommands();

    /**
     * Gets additional tool-buttons.
     *
     * @return buttons additional tool-buttons
     */
    Vector<ToolButton> getAdditionalButtons();

    /**
     * Gets the path to the tools' directory.
     *
     * @return the path to the tools' directory.
     */
    String getToolDirPath();
}