package de.renew.navigator.models;

import java.io.File;


/**
 * This abstract class represents elements within a tree structure.
 *
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-25
 */
public abstract class TreeElement extends Model {

    /**
     * The parent tree element.
     */
    private Model _parent;

    /**
     * The name to display for this tree element.
     */
    private String _name;

    /**
     * Whether this tree element is excluded from the view.
     */
    private boolean _excluded;

    /**
     * Which file is represented by this tree element.
     */
    private File _file;

    /**
     * Propagates the change of this model element.
     */
    @Override
    protected synchronized void setChanged() {
        super.setChanged();

        if (_parent == null) {
            return;
        }

        _parent.setChanged();
    }

    /**
     * This is a getter which gets the parent of the Tree-Element.
     * @return parent the model of the parent of the Tree-Element.
     */
    public Model getParent() {
        return _parent;
    }

    /**
     * This is a setter which sets the parent of the Tree-Element.
     * @param parent The Model of the parent of the Tree-Element, that should be set.
     */
    public void setParent(Model parent) {
        this._parent = parent;
        setChanged();
    }

    /**
     * This is a getter which gets the name of the Tree-Element.
     * @return name the String of the name of the Tree-Element.
     */
    public String getName() {
        return _name;
    }

    /**
     * This is a setter which sets the name of the Tree-Element.
     * @param name The name of the Tree-Element, that should be set.
     */
    public void setName(String name) {
        this._name = name;
        setChanged();
    }

    /**
     * This is a getter which indicates, whether the Tree-Element is excluded.
     * @return excluded the boolean, whether the Tree-Element is excluded.
     */
    public boolean isExcluded() {
        return _excluded;
    }

    /**
     * This is a setter which sets the excluded state of the Tree-Element.
     * @param excluded The boolean, whether the Tree-Element is excluded, that should be set.
     */
    public void setExcluded(boolean excluded) {
        this._excluded = excluded;
        setChanged();
    }

    /**
     * This is a getter which gets the file of the Tree-Element.
     * @return file the File of the Tree-Element.
     */
    public File getFile() {
        return _file;
    }

    /**
     * This is a setter which sets the file of the Tree-Element.
     * @param file The File of the Tree-Element, that should be set.
     */
    public void setFile(File file) {
        this._file = file;
        setChanged();
    }

    /**
     * Expands all nodes in this TreeElement.
     */
    public void expandAll() {}

    /**
     * Returns a string representation of the TreeElement.
     * @return a string that contains the name and file of the TreeElement.
     */
    @Override
    public String toString() {
        return "TreeElement{" + "name='" + _name + '\'' + ", file=" + _file + '}';
    }
}