package de.renew.navigator.gui;

import java.awt.Point;
import java.io.File;
import java.util.Arrays;

import CH.ifa.draw.application.AbstractFileDragDropListener;
import de.renew.navigator.FilesystemController;


/**
 * @version Renew 2.5
 */
class DragDropListener extends AbstractFileDragDropListener {
    private final FilesystemController _filesystemCtrl;

    DragDropListener(FilesystemController filesystemController) {
        this._filesystemCtrl = filesystemController;
    }

    @Override
    protected void handleFilesDrawing(File[] files, Point loc) {
        _filesystemCtrl.loadRootDirectories(Arrays.asList(files));
    }

    @Override
    protected void handleFilesImage(File[] files, Point loc) {
        // not implemented since the navigator does not need to handle images as of now
    }
}