package de.renew.call;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.LateExecutable;
import de.renew.unify.Tuple;


class NotifyExecutable implements LateExecutable {
    SynchronisationRequest _synchronisation;
    Tuple _parameters;

    NotifyExecutable(SynchronisationRequest synchronisation, Tuple parameters) {
        this._synchronisation = synchronisation;
        this._parameters = parameters;
    }

    @Override
    public int phase() {
        return COMPLETION_NOTIFY;
    }

    // I'll return quickly.
    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _synchronisation._resultParameters = _parameters;
        _synchronisation._resultSemaphor.V();
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable throwable) {
        // This should not happen, strictly speaking.
        // We do not perform any actions in order to
        // enable the user to detect this unusual situation.
    }
}