package de.renew.minimap.component;

import java.awt.Dimension;

import bibliothek.gui.dock.common.DefaultSingleCDockable;

import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;

/**
 * A {@link bibliothek.gui.dock.common.DefaultSingleCDockable} frame for use with the MiniMap.
 *
 * @author Christian Roeder
 */
public class MiniMapFrame {
    private static DefaultSingleCDockable _frame;

    // Private to prevent anyone from instantiating
    private MiniMapFrame() {}

    /**
     * Ensures that only one instance of the frame ever exists
     *
     * @param workbench workbench to add the window to
     * @return the frame
     */
    public static DefaultSingleCDockable getFrame(Workbench workbench) {
        if (_frame == null) {
            createMiniMapFrame(workbench);
        }

        return _frame;
    }

    /**
     * Dispose of the MiniMapFrame.
     */
    public static void destroyMiniMapFrame() {
        _frame.getControl().removeDockable(_frame);
        _frame = null;
    }

    /**
     * Create the MiniMap frame.
     */
    private static void createMiniMapFrame(Workbench workbench) {
        DefaultSingleCDockable miniMapFrame = new DefaultSingleCDockable("Mini Map");
        miniMapFrame.setTitleText("Mini Map");
        miniMapFrame.setCloseable(true);
        MiniMapPanel miniMapPanel = new MiniMapPanel();
        miniMapPanel.setPreferredSize(new Dimension(320, 640));
        miniMapPanel.setVisible(true);
        miniMapFrame.add(miniMapPanel);

        workbench.addViewWindow(miniMapFrame, WorkbenchImpl.UPPER_RIGHT_GROUP);
        workbench.registerFocusListener(miniMapPanel);
        _frame = miniMapFrame;
    }
}
