<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Logging

## User Guide

The _Logging_ plugin provides simulation trace windows and
related configuration facilities in the Renew GUI.

To present the simulation trace graphically, the _Logging_ plugin
attaches to the Log4j framework, receives simulation-related events,
groups them into simulation steps, presents them as a table in the
graphical user interface, and allows the user to navigate directly
to the net elements that caused the events.  
Multiple simulation trace views can be defined that present only
simulation steps affecting some specific net or net element (place or
transition).  
The Renew simulation configuration dialog is extended by a logging
configuration tab that provides facilities to create, configure and
delete these views as well as other simulation-related Log4j appenders.

### Features

- Get a convenient overview of all simulation-related logging events
- Find the net element that caused a log entry
- Add and configure your own Log4j appenders

### Example Usage

1. Open a net that can be simulated.
2. Run the simulation or execute a simulation step.
3. Open the logging window via `Simulation --> Show Simulation Trace`.

To find nets or a net element related to a log entry, select the desired entry and then use the context menu of that entry.
To configure the appenders, open the configuration window via `Simulation --> Configure Simulation... --> Logging`.

### Provided Commands

This plugin does not provide any commands.

### Installation

Install _Logging_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and libraries:

<!-- must match the `module-info.java` -->

- `Gui`: To draw the logging elements on the screen and get access to classes like `Drawing`
- `log4j`: Logging framework
- `docking.frames.common`: Add a new window to the screen


### Configuration

All configuration takes place via the configuration Gui explained above.

## Developer Guide
	
### Core Classes

- `StepTrace`: Stores the log events for a single simulation step.
- `StepTraceRepository`: The interface for a repository which stores StepTraces with logging events of a simulation run.
- `GuiAppender`: A Log4j Appender implementation that collects Renew simulator log events and dispatches them to LoggerRepository instances.
- `LoggingFrame`:  GUI for showing the trace messages produced during the simulation of petri nets

### How to Extend

_Logging_ is not meant to be extended. But it exposes the following public interfaces:

- `AppenderBuilder` - an appender builder is used to create new initialized instances of the different types of appenders, which can be used for logging
- `RepositoryChangeListener` - methods to inform about changes in a StepTraceRepository
- `StepTraceChangeListener` - informs about changes in a StepTrace object, like an added log event message
- `StepTraceRepository` - the interface for a repository which stores StepTraces with logging events of a simulation run


### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- It is currently not possible to open the logging window before a simulation is started.
- The logging window has to be closed and reopened to show the logging events of a new simulation. 

<!-- Contribution Info -->

<!-- License -->
