package de.renew.logging;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class CliColorTest {
    @Test
    public void testFormat() {
        //given
        String exampleString = "\u001b[" + "1;" + "32" + "m" + "Test string " + "\u001b[m";

        //when
        String actualString = CliColor.color("Test string ", CliColor.BOLD, CliColor.GREEN);

        //then
        assertEquals(exampleString, actualString);
    }

    @Test
    public void testToString() {
        //given
        CliColor format1 = CliColor.BLUE;

        //when
        String format1String = format1.toString();

        //then
        assertEquals("34", format1String);
    }

    @Test
    public void testColor() {
        //given
        CliColor formatBlue = CliColor.BLUE;
        String expectedString = "\u001B[34mTest string\u001B[m";

        //when
        String actualString = formatBlue.color("Test string");

        //then
        assertEquals(expectedString, actualString);
    }
}
