package de.renew.plugin.load;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


/**
 * This interface combines the basic methods of the interface
 * {@link PropertyChangeListener}<br>
 * and it is used to notify the splashscreen whenever new information is available for display
 * @author Eva Mueller
 * @date Nov 27, 2010
 */
public interface ISplashscreenPlugin extends PropertyChangeListener {

    /**
     * Notify about the change of a property.<br>
     * If propertyName is <b>progress</b> then the {@link javax.swing.JProgressBar} will be
     * updated.<br>
     * If propertyName is <b>pluginLoaded</b> then the {@link javax.swing.JTextArea} will be
     * updated.
     *
     * @param evt the event where the property Changes
     */
    @Override
    void propertyChange(PropertyChangeEvent evt);

    /**
     * Closes the component once its task is fulfilled.
     */
    void closeSplashScreen();
}