package de.renew.plugin;

import java.util.Collection;


/**
 * This Exception is thrown by the DependencyCheckList if a
 * dependency relation is broken.
 *
 * @author J&ouml;rn Schumacher &amp; Hamed M.
 * @version 30.11.2020
 */
public class DependencyNotFulfilledException extends Exception {
    /**
     * Collection as parameters to have excepted elements
     */
    private Collection<?> _elements;

    /**
     * Constructor for the DependencyNotFulfilledException.
     * The exception checks for dependency fulfillment. If it does not, an exception
     * without message is thrown.
     */
    public DependencyNotFulfilledException() {
        super();
    }

    /**
     * This is a constructor for the DependencyNotFulfilledException.
     * The exception checks whether a dependency is being fulfilled, if it is not the case then
     * an error message is being displayed. 
     * @param message A String is being put in on DependencyNotFulfilledException
     */
    public DependencyNotFulfilledException(String message) {
        super(message);
    }

    /**
     * This is a constructor for DependencyNotFulfilledException also. The Exception checks whether a
     * dependency is being fulfilled, if it is not the case error message is being displayed.
     * Additionally, the Exception can contain elements in contrast
     * to the other overloaded method with same name.
     * @param message A String is being put in on DependencyNotFulfilledException
     * @param elements of Type Collection as parameters to have excepted elements
     */
    public DependencyNotFulfilledException(String message, Collection<?> elements) {
        super(message);
        this._elements = elements;
    }

    /**
     * This method returns the contained elements of a given Collection as a getter Method. 
     * @return _elements  An Element is being returned
     */
    public Collection<?> getElements() {
        return _elements;
    }
}
