package de.renew.imagenetdiff;


/**
 * Class for the command-line-based epsDiff command in the {@code ImageNetDiff} plugin.
 * @author Lawrence Cabac
 *
 */
public class EPSDiffClCommand extends AbstractDiffClCommand {
    private static final String EPSDIFF_COMMAND = "epsDiff";

    /**
     * Constructor of EPSDiffClCommand. Initializes the fields of the superclass.
     */
    public EPSDiffClCommand() {
        super();
        _diffCommand = new EPSDiffCommand();
        _command = EPSDIFF_COMMAND;
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    @Override
    public String getDescription() {
        return "Synopsis: " + getName() + " file1 [file2]. Constructs a diff image.\n"
            + "                if only one argument is given " + getName()
            + " assumes diff against \n"
            + "                svn base file (in <filepath>/.svn/text-base/<filename>.svn-base).\n"
            + "                Command produces EPS files of drawings in temp folder.";

    }
}