package de.renew.gui;

import java.awt.Dimension;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertNotNull;

public class CPNDrawingViewFactoryTest {

    private CPNDrawingViewFactory factoryUnderTest;

    @BeforeEach
    public void setUp() {
        StandardDrawingEditor editor = Mockito.mock(StandardDrawingEditor.class);
        this.factoryUnderTest = new CPNDrawingViewFactory(editor);
    }

    /**
     * Test case to ensure that for CPNDrawings, a CPNDrawingView is returned.
     */
    @Test
    public void testCreateViewFromDrawingCPNDrawing() {
        // given
        Drawing drawing = Mockito.mock(CPNDrawing.class);
        Dimension dimension = new Dimension(1, 2);
        Mockito.when(drawing.defaultSize()).thenReturn(dimension);

        // when
        StandardDrawingView view = this.factoryUnderTest.createViewFromDrawing(drawing);

        // then
        assertNotNull(view, "view was not initialized.");
        assertThat(view).isInstanceOf(CPNDrawingView.class);
    }

    /**
     * Test case to ensure that for CPNInstanceDrawing, a CPNInstanceDrawingView is returned.
     */
    @Test
    public void testCreateViewFromDrawingCPNInstanceDrawing() {
        // given
        Drawing drawing = Mockito.mock(CPNInstanceDrawing.class);
        Dimension dimension = new Dimension(1, 2);
        Mockito.when(drawing.defaultSize()).thenReturn(dimension);

        // when
        StandardDrawingView view = this.factoryUnderTest.createViewFromDrawing(drawing);

        // then
        assertNotNull(view, "view was not initialized.");
        assertThat(view).isInstanceOf(CPNInstanceDrawingView.class);
    }

    /**
     * Test case to ensure that for TokenBagDrawing, a StandardDrawingView is returned.
     * (see RNWCOMM-351)
     */
    @Test
    public void testCreateViewFromDrawingTokenBagDrawing() {
        // given
        Drawing drawing = Mockito.mock(TokenBagDrawing.class);
        Dimension dimension = new Dimension(1, 2);
        Mockito.when(drawing.defaultSize()).thenReturn(dimension);

        // when
        StandardDrawingView view = this.factoryUnderTest.createViewFromDrawing(drawing);

        // then
        assertNotNull(view, "view was not initialized.");
        assertThat(view).isInstanceOf(StandardDrawingView.class);
    }

    /**
     * Test case to ensure that for not specifically treated Drawing,
     * a StandardDrawingView is returned.
     */
    @Test
    public void testCreateViewFromDrawingOtherDrawingType() {
        // given
        Drawing drawing = Mockito.mock(Drawing.class);
        Dimension dimension = new Dimension(1, 2);
        Mockito.when(drawing.defaultSize()).thenReturn(dimension);

        // when
        StandardDrawingView view = this.factoryUnderTest.createViewFromDrawing(drawing);

        // then
        assertNotNull(view, "view was not initialized.");
        assertThat(view).isInstanceOf(StandardDrawingView.class);
    }
}
