package de.renew.gui.pnml.converter;

import org.w3c.dom.Element;

import CH.ifa.draw.figures.TextFigure;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.pnml.creator.PNMLCreator;


/**
 * Used to convert between the contents of a {@link de.renew.gui.CPNDrawing}
 * (in the form of {@link CH.ifa.draw.framework.Figure} objects)
 * and the contents of an {@link Element} representing the same net
 * in a PNML file.
 * <p>
 * See also {@link Converter}.
 */
public interface NetConverter {

    /**
     * {@link #isAttribute(String)} for the name of the PNML tag given as an {@link Element}.
     *
     * @param label the PNML tag in form of an {@link Element}
     * @return whether the PNML tag contains an Attribute
     */
    boolean isAttribute(Element label);

    /**
     * If true the tag with the given name should be created with {@link de.renew.gui.pnml.creator.AttributeCreator},
     * otherwise with {@link de.renew.gui.pnml.creator.AnnotationCreator}.
     *
     * @param tagName the tag name to be checked
     * @return if the tagName contains an Attribute
     */
    boolean isAttribute(String tagName);

    /**
     * Whether the label should be parsed by the {@link de.renew.gui.pnml.parser.AnnotationParser}.
     *
     * @param label the label to be checked
     * @return whether the label is an Annotation or not
     */
    boolean isAnnotation(Element label);

    /**
     * Whether the label should be parsed by the {@link de.renew.gui.pnml.parser.AnnotationParser}.
     *
     * @param label the label to be checked
     * @return whether the label is an Annotation or not
     */
    boolean isInRenewAnnotation(Element label);

    /**
     * Create a {@link CPNTextFigure} with the right type
     * by calling {@link CPNTextFigure#CPNTextFigure(int)}.
     *
     * @param annotation according to its nodeName
     * @return there CPNTextFigure
     */
    TextFigure convertAnnotationToTextFigure(Element annotation);

    /**
     * Check the given annotation figure for syntax errors,
     * generate the corresponding tag structure
     * and return it as an {@link Element}.
     *
     * @param figure        which is being checked
     * @param pnmlCreator   is used when the given figure is a tool inscription
     * @param parentVirtual wheither the parent is virtual or not
     * @return the element as an PNML
     */
    Element annotationToPNML(CPNTextFigure figure, PNMLCreator pnmlCreator, boolean parentVirtual);

    /**
     * Converts the given attributes attribute name according to its type and parent, if the parent is named <em>arc</em>
     *
     * @param attribute which is being converted from
     * @return the converted attribute name
     */
    String convertAttributeNameToRenewName(Element attribute);

    /**
     * @return Whether to create a {@code page} tag within the {@code net} tag.
     */
    boolean createPageTag();
}