package de.renew.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.util.ColorMap;
import de.renew.remote.NetInstanceAccessor;


public class NetInstanceHandle extends ClickHandle {
    final NetInstanceAccessor netInstance;
    private static final org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(NetInstanceHandle.class);

    /**
     * Creates a new handle within the given rectangle, surrounded by a blue
     * border, displaying the name of the instance.
     **/
    public NetInstanceHandle(Figure owner, Rectangle box, NetInstanceAccessor netInstance) {
        super(owner, ColorMap.NONE, Color.blue, box);
        this.netInstance = netInstance;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        noChangesMade();
        try {
            InstanceDrawing instDraw = CPNInstanceDrawing.getInstanceDrawing(netInstance);

            // If the instance drawing could not be created, don't open a window...
            if (instDraw != null) {

                ((StandardDrawingEditor) view.editor()).openDrawing(instDraw);
            }
        } catch (RemoteException e) {
            logger.error(e.getMessage(), e);
            JOptionPane.showMessageDialog(
                null, "A problem occurred: " + e + "\n" + "See the console for details.", "Renew",
                JOptionPane.ERROR_MESSAGE);
        }
    }
}