# FormalismGui

## User Guide

The `FormalismGui` plugin provides a gui interface for the Formalism Component.
It offers a Menu in which the currently active formalism can be chosen.

### Features

- Offers selection of the simulation formalism via the gui
- Provides menus and palettes specific to the added compiler that may offer new drawing tools or can be used to configure the Plugin

### Example Usage

1. In the Renew 'Simulation' menu compilers can be selected via 'Formalism'.
2. Select a compiler. If it has a specific palette, it will be shown in the sidebar.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->
None.

### Installation

Install _FormalismGui_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Gui`: drawing tools for compiler-options
- `log4j`: Logging framework

### Configuration

During the initialization of SamplePlugin, NO properties are read from the `renew.properties` file in the Renew root directory.

## Developer Guide

### Core Classes

- `FormalismGuiPlugin`: Provides a gui interface presenting all choices that are available with the formalism plugin.
- `JavaGuiCreator`: This class is used when the Java Net Compiler is chosen, provides menu items and palette for the compilers.

### How to Extend

- `de.renew.formalism.gui.FormalismGuiCreator`: This interface is implemented by classes that allow special operations if a compiler is activated.

### Additional Information

None.

<!-- Common issues, explanations for inconsistencies, etc. -->



