package de.renew.formalism;

import org.junit.jupiter.api.Test;

import de.renew.formalism.function.CastFunction;
import de.renew.unify.Impossible;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class CastFunctionTest {
    @Test
    public void testFunctionWithCorrectType() throws Impossible {
        //given
        final int one = 1;
        var castFunction = new CastFunction(Integer.class);
        //when
        var value = castFunction.function(one);
        //then
        assertEquals(one, value);
    }

    @Test
    public void testFunctionWithWrongType() {
        //given
        final String s = "Test";
        var castFunction = new CastFunction(Integer.class);
        //when
        //then
        assertThrows(Impossible.class, () -> castFunction.function(s));
    }
}
