package de.renew.formalism.function;

import de.renew.expression.NoArgFunction;
import de.renew.unify.Impossible;

/**
 * Represents a function that always returns the same constant value.
 */
public class ConstantFunction implements NoArgFunction {
    /**
     * The value that this function always returns.
     */
    private final Object _obj;

    /**
     * Constructs an instance of this class given an object.
     *
     * @param obj the object
     */
    public ConstantFunction(Object obj) {
        this._obj = obj;
    }

    @Override
    public Object function() throws Impossible {
        return _obj;
    }
}