package de.renew.formalism.bool;

import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowCompilerFactory;


/**
 * Class which implements the interface ShadowCompilerFactory of the Simulator plugin.
 * The class is used to create SingleBoolNetCompiler.
 * This enables the usage of the BoolNetCompiler in Renew.
 * Its method returns an instance of the class SingleBoolNetCompiler.
 */
public class BoolNetCompiler implements ShadowCompilerFactory {
    private static final long serialVersionUID = -2063740003806585503L;

    @Override
    public ShadowCompiler createCompiler() {
        return new SingleBoolNetCompiler();
    }
}