package de.renew.formalism;

import java.util.HashMap;
import java.util.Iterator;

import de.renew.shadow.ShadowCompilerFactory;


/**
 * @author 6schumac
 * <p>
 * A class that keeps track of all available shadow compilers.
 * These compilers represent the different formalisms in which a net may be compiled.
 */
public class CompilerStore extends HashMap<String, ShadowCompilerFactory> {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(CompilerStore.class);

    CompilerStore() {
        super();
    }

    /**
     * Register a RenewMode under the specified name.
     */
    public void addCompilerFactory(String compilerName, ShadowCompilerFactory compilerFactory) {
        LOGGER.debug("CompilerStore: compiler " + compilerName + " registered.");
        put(compilerName, compilerFactory);
    }

    /**
     * @return an Iterator containing the (String) names of the registered Modes
     */
    Iterator<String> getKnownFormalisms() {
        return keySet().iterator();
    }
}