package de.uni_hamburg.fs;

import org.junit.jupiter.api.Test;

import collections.CollectionEnumeration;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

class EqualityTest {

    @Test
    void testEqualsWithIdenticalFeatureStructures() {
        // given
        FeatureStructure fs1 = new FeatureStructure(new BasicType("test").newNode());
        FeatureStructure fs2 = new FeatureStructure(new BasicType("test").newNode());

        // when
        boolean result = Equality.equals(fs1, fs2);

        // then
        assertThat(result).isTrue();
    }

    @Test
    void testEqualsWithDifferentTypes() {
        // given
        FeatureStructure fs1 = new FeatureStructure(new BasicType("test1").newNode());
        FeatureStructure fs2 = new FeatureStructure(new BasicType("test2").newNode());

        // when
        boolean result = Equality.equals(fs1, fs2);

        // then
        assertThat(result).isFalse();
    }

    @Test
    void testEqualsWithDifferentFeatures() {
        // given
        FeatureStructure fs1 = mock(FeatureStructure.class);
        FeatureStructure fs2 = mock(FeatureStructure.class);
        Node root1 = mock(Node.class);
        Node root2 = mock(Node.class);
        Type type = mock(Type.class);
        Name featureName = new Name("testFeature");
        CollectionEnumeration features1 = mock(CollectionEnumeration.class);

        when(fs1.getRoot()).thenReturn(root1);
        when(fs2.getRoot()).thenReturn(root2);
        when(root1.getType()).thenReturn(type);
        when(root2.getType()).thenReturn(type);
        when(root1.featureNames()).thenReturn(features1);
        when(root2.featureNames()).thenReturn(EmptyEnumeration.INSTANCE);
        when(features1.hasMoreElements()).thenReturn(true, false);
        when(features1.numberOfRemainingElements()).thenReturn(1);
        when(features1.nextElement()).thenReturn(featureName);
        when(root2.hasFeature(featureName)).thenReturn(false);

        // when
        boolean result = Equality.equals(fs1, fs2);

        // then
        assertThat(result).isFalse();
    }

}