package de.renew.gui.fs;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Figure;
import de.renew.gui.AssocArrowTip;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceNodeFigure;
import de.renew.gui.TransitionNodeFigure;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;


/**
 * Connection class for a feature arrow connection.
 */
public class FeatureConnection extends LineConnection implements InscribableFigure {
    /**
     * Arc to be used for connection.
     */
    public final static FeatureConnection NORMAL_ARC = new FeatureConnection();

    /**
     * The shadow of this feature connection.
     * Initially <code>null</code>, will be created
     * when needed.
     * <p>
     * This field is transient because its information
     * can be regenerated via <code>buildShadow(...)</code>.
     * </p>
     **/
    private transient ShadowNetElement _shadow = null;

    /**
     * Constructor for the connection.
     */
    public FeatureConnection() {
        fArrowTipClass = AssocArrowTip.class;
        setStartDecoration(null);
        setEndDecoration(new AssocArrowTip());
    }

    /** Build a shadow in the given shadow net.
      *  This shadow is stored as well as returned.
      */
    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        //      shadow = createShadow(getStartFSNode(),getEndFSNode());
        //      shadow.context = this;
        return _shadow;
    }

    //protected ShadowNetElement createShadow(ShadowFSNode from, ShadowFSNode to);


    /** Get the associated shadow, if any.
     */
    @Override
    public ShadowNetElement getShadow() {
        return _shadow;
    }

    //  protected ShadowFSNode getStartFSNode() {
    //      return getFSNode(startFigure());
    //  }
    //  protected ShadowFSNode getEndConcept() {
    //      return getFSNode(endFigure());
    //  }
    //  private static ShadowFSNode getFSNode(Figure figure) {
    //      if (canConnect(figure)) {
    //  return (ShadowFSNode)((ShadowHolder)figure).getShadow();
    //    } else {
    //  return null;
    //    }
    //  }
    private static boolean canConnect(Figure figure) {
        return figure instanceof PlaceNodeFigure || figure instanceof TransitionNodeFigure
            || figure instanceof FSFigure;
    }

    @Override
    public boolean canConnect(Figure start, Figure end) {
        return canConnect(start) && canConnect(end);
    }

    @Override
    public void release() {
        super.release();


        //    if (shadow!=null)
        //      shadow.discard();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (!name.equals("ArrowMode")) {
            super.setAttribute(name, value);
        }
    }
}