package de.renew.gui.fs;

import CH.ifa.draw.framework.ConnectionFigure;
import de.renew.formalism.fs.ShadowAssoc;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.gui.AssocArrowTip;
import de.renew.gui.InscribableFigure;
import de.renew.shadow.ShadowNetElement;


/**
 * Connection class for an association arrow connection.
 */
public class AssocConnection extends ConceptConnection
    implements InscribableFigure, ConnectionFigure
{
    /**
     * Logger for the class.
     */
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(AssocConnection.class);

    /**
     * Constructor for the connection.
     */
    public AssocConnection() {
        super(new AssocArrowTip());
    }

    @Override
    protected ShadowNetElement createShadow(ShadowConcept from, ShadowConcept to) {
        // logger.debug("assoc shadow created!");
        return new ShadowAssoc(from, to);
    }
}