package de.renew.formalism.fs;

import java.util.Vector;

import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Path;

import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Tuple;
import de.renew.unify.Unify;
import de.renew.unify.Variable;


public class FSUnifyExpression implements Expression {
    FeatureStructure _template;
    Vector<Path> _paths;
    Vector<Object> _exprs;

    //  private boolean debug=false;
    //  public FSUnifyExpression(FeatureStructure template,
    //          Vector paths, Vector exprs, boolean debug) {
    //      this(template,paths,exprs);
    //      this.debug=debug;
    //  }
    public FSUnifyExpression(FeatureStructure template, Vector<Path> paths, Vector<Object> exprs) {
        this._template = template;
        this._paths = paths;
        this._exprs = exprs;
    }

    public FeatureStructure getTemplate() {
        return _template;
    }

    public Vector<Path> getPaths() {
        return _paths;
    }

    public Vector<Object> getExprs() {
        return _exprs;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public Class<?> getType() {
        return FeatureStructure.class;
    }

    @Override
    public Object startEvaluation(
        VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible
    {
        if (_exprs.size() > 0) {
            FSUnifier unifier = new FSUnifier(_template, _paths, recorder); //,debug);

            for (int i = 0; i < _exprs.size(); i++) {
                Expression expr = (Expression) _exprs.elementAt(i);
                Unify.unify(
                    unifier.getVariable(i), expr.startEvaluation(mapper, recorder, checker),
                    recorder);
            }

            return unifier._result.getValue();
        } else {
            return _template;
        }
    }

    // In former times, features structures were not allowed to be used
    // in actions. This was changed to become more flexible, but
    // the liability for exception handling is on the user now.
    @Override
    public Object registerCalculation(
        VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible
    {
        Tuple tuple = new Tuple(_exprs.size());
        for (int i = 0; i < _exprs.size(); i++) {
            Expression expr = (Expression) _exprs.elementAt(i);
            Unify.unify(
                tuple.getComponent(i), expr.registerCalculation(mapper, recorder, checker),
                recorder);
        }

        Variable source = new Variable(tuple, recorder);
        Variable target = new Variable();

        checker.addLateVariable(source, recorder);
        checker.addCalculated(FeatureStructure.class, target, source.getValue(), recorder);

        return target.getValue();
    }

    @Override
    public String toString() {
        final int sbSize = 1000;
        final String variableSeparator = ", ";
        final StringBuffer sb = new StringBuffer(sbSize);
        sb.append("FSUnifyExpr(");
        sb.append("tmpl: ").append(_template);
        sb.append(variableSeparator);
        sb.append("paths: ").append(_paths);
        sb.append(variableSeparator);
        sb.append("exprs: ").append(_exprs);
        sb.append(")");
        return sb.toString();
    }
}