package de.renew.faformalism.shadow;

import java.util.Enumeration;
import java.util.Hashtable;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowLookupExtension;
import de.renew.shadow.ShadowLookupExtensionFactory;


public class FAShadowLookupExtension implements ShadowLookupExtension {
    private static final ShadowLookupExtensionFactory FACTORY = new Factory();
    private final Hashtable<ShadowFAState, Place> _stateMap;
    private final Hashtable<ShadowFAArc, Transition> _arcMap;

    public FAShadowLookupExtension() {
        _stateMap = new Hashtable<ShadowFAState, Place>();
        _arcMap = new Hashtable<ShadowFAArc, Transition>();
    }

    public static FAShadowLookupExtension lookup(ShadowLookup lookup) {
        return (FAShadowLookupExtension) lookup.getShadowLookupExtension(FACTORY);
    }

    //------------------------------ ShadowFAState management ----------   
    public void set(ShadowFAState shadowFAState, Place place) {
        _stateMap.put(shadowFAState, place);
    }

    //------------------------------ ShadowFAArc management ----------
    public void set(ShadowFAArc shadowFAArc, Transition transition) {
        _arcMap.put(shadowFAArc, transition);
    }

    //------------------------------ ShadowFAState management ----------
    public Place get(ShadowFAState shadowFAState) {
        return _stateMap.get(shadowFAState);
    }

    //------------------------------ ShadowFAArc management ----------
    public Transition get(ShadowFAArc shadowFAArc) {
        return _arcMap.get(shadowFAArc);
    }

    public Enumeration<ShadowFAState> allFAStates() {
        return _stateMap.keys();
    }


    public Enumeration<ShadowFAArc> allFAArcs() {
        return _arcMap.keys();
    }

    public static class Factory implements ShadowLookupExtensionFactory {
        @Override
        public String getCategory() {
            return "de.renew.fa";
        }

        @Override
        public ShadowLookupExtension createExtension() {
            return new FAShadowLookupExtension();
        }
    }
}