package de.renew.fa.service;

import java.io.File;
import java.io.FileOutputStream;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.fa.FADrawing;
import de.renew.fa.XFAFileFilter;


/**
 * Defines the export XFA format for a finite automata drawing (<code>FADrawing</code>).
 * {@link de.renew.fa.service.XFAFormat}
 * @author jo
 *
 */
public class XFAExportFormat extends ExportFormatAbstract {
    /**
     * Creates an export XFAExportFormat to be used in the UI.
     */
    public XFAExportFormat() {
        super("XFA", new XFAFileFilter());

    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        if (drawing instanceof FADrawing) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean canExportNto1() {
        return false;
    }

    @Override
    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);

            FAFileParser.writeToXFA(stream, drawing);
        }
        assert (result != null) : "Failure in XFAExportFormat: result == null";
        return result;
    }

    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        File file = null;
        for (int i = 0; i < drawings.length; i++) {
            file = export(drawings[i], path);
        }
        return file;
    }
}