/*
 * Created on Aug 1, 2005
 *
 */

package de.renew.fa.model;


/**
 * Represents a simple implementation for a single letter.
 *
 * @author cabac
 */
public class LetterImpl implements Letter {
    private String _name;

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LetterImpl) {
            return _name.equals(((LetterImpl) obj).getName());
        } else {
            return false;
        }
    }

    /**
     * Creates a letter with a given token.
     *
     * @param token the token representing the letter in the sets finite automata
     */
    public LetterImpl(String token) {
        _name = token;
    }

    @Override
    public String getName() {
        return _name;
    }

    @Override
    public String toString() {
        return "" + _name;
    }

    @Override
    public int hashCode() {
        return _name.hashCode();
    }

    @Override
    public int compareTo(Object o) {
        return ((Letter) o).getName().compareTo(getName());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}