package completer;

import org.junit.jupiter.api.Test;

import de.renew.console.completer.FirstWhitespaceArgumentDelimiter;

import static org.assertj.core.api.Assertions.assertThat;

public class FirstWhitespaceArgumentDelimiterTest {
    @Test
    void testIsDelimiterCharOneWhitespace() {
        //given
        CharSequence buffer = " ";
        int pos = 0;
        FirstWhitespaceArgumentDelimiter delimiter = new FirstWhitespaceArgumentDelimiter();
        //when
        boolean result = delimiter.isDelimiterChar(buffer, pos);
        //then
        assertThat(result).isTrue();
    }

    @Test
    void testIsDelimiterCharMixedWhitespace() {
        //given
        CharSequence buffer = "Hello World";
        int pos = 5;
        FirstWhitespaceArgumentDelimiter delimiter = new FirstWhitespaceArgumentDelimiter();
        //when
        boolean result = delimiter.isDelimiterChar(buffer, pos);
        //then
        assertThat(result).isTrue();
    }

    @Test
    void testIsDelimiterCharNonWhitespace() {
        //given
        CharSequence buffer = "HelloWorld";
        int pos = 5;
        FirstWhitespaceArgumentDelimiter delimiter = new FirstWhitespaceArgumentDelimiter();
        //when
        boolean result = delimiter.isDelimiterChar(buffer, pos);
        //then
        assertThat(result).isFalse();
    }

    @Test
    void testIsDelimiterCharTwoWhitespace() {
        //given
        CharSequence buffer = "  ";
        int pos = 1;
        FirstWhitespaceArgumentDelimiter delimiter = new FirstWhitespaceArgumentDelimiter();
        //when
        boolean result = delimiter.isDelimiterChar(buffer, pos);
        //then
        assertThat(result).isFalse();
    }
}
