package de.renew.console.completer;

import de.renew.console.completer.RenewArgumentCompleter.AbstractArgumentDelimiter;

/**
 *This class extends AbstractArgumentDelimiter and
 * identifies the first whitespace character in a string as the argument delimiter.
 * It ensures that only the first occurrence of whitespace is treated as a delimiter,
 * while any subsequent whitespaces are ignored.
 */

public class FirstWhitespaceArgumentDelimiter extends AbstractArgumentDelimiter {

    /**
     * Constructs a {@code FirstWhitespaceArgumentDelimiter}.
     * This delimiter treats only the first whitespace as an argument separator.
     */
    public FirstWhitespaceArgumentDelimiter() {}

    @Override
    public boolean isDelimiterChar(final CharSequence buffer, final int pos) {
        boolean result = Character.isWhitespace(buffer.charAt(pos));
        if (result) {
            for (int i = 0; i < pos; i++) {
                if (Character.isWhitespace(buffer.charAt(i))) {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }
}