package CH.ifa.draw.standard;

import java.util.Vector;

import org.junit.jupiter.api.Test;

import CH.ifa.draw.figures.CompositeAttributeFigure;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * @author Fabian Sobanski
 *
 */
public class StandardDrawingViewTest {
    @Test
    public void test() {
        Vector<Figure> v = new Vector<Figure>();
        EllipseFigure efigure = new EllipseFigure();
        ChildFigure cfigure = new TextFigure(true);
        efigure.addChild(cfigure);
        v.add(efigure);
        EllipseFigure e2figure = new EllipseFigure();
        v.add(e2figure);
        Vector<Figure> result = StandardDrawingView.expandFigureVector(v);
        assertTrue(result.contains(efigure));
        assertTrue(result.contains(e2figure));
        assertTrue(result.contains(cfigure));
    }

    @Test
    void testRemoveAll() {
        Vector<Figure> v = new Vector<Figure>();
        EllipseFigure e1figure = new EllipseFigure();
        EllipseFigure e2figure = new EllipseFigure();
        EllipseFigure e3figure = new EllipseFigure();
        CompositeAttributeFigure comp = new CompositeAttributeFigure();
        Drawing drawing = new StandardDrawing();
        StandardDrawingView drawingView = new StandardDrawingView(null, 0, 0);

        comp.getAttached().add(e1figure);
        comp.getAttached().add(e2figure);
        comp.getAttached().add(e3figure);

        e1figure.addFigureChangeListener(comp);
        e2figure.addFigureChangeListener(comp);
        e3figure.addFigureChangeListener(comp);

        drawingView.setDrawing(drawing);
        drawingView.add(e1figure);
        drawingView.add(e2figure);
        drawingView.add(e3figure);

        drawingView.removeAll(comp.getAttached());
        assertFalse(drawingView.drawing().figures().hasMoreElements());
    }
}