package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class PSFileFilterTest {
    private PSFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new PSFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .ps extension gets accepted, as it should.
     */
    @Test
    public void testAcceptPS() {
        //given
        File file = new File("test.ps");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-PS-File is rejected correctly.
     */
    @Test
    public void testAcceptNotPs() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created PS-Filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Post Script File");
    }

}