package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class ImageFileFilterTest {

    private final ImageFileFilter filter = new ImageFileFilter();

    @Test
    void testDescription() {
        assertEquals(
            "Image File (png, jpg, gif)", filter.getDescription(),
            "The description of the image file must match");
    }

    @Test
    void testAcceptsPng() {
        assertTrue(filter.accept(new File("image.png")), ".png should be accepted");
    }

    @Test
    void testAcceptsJpgAndJpeg() {
        assertTrue(filter.accept(new File("image.jpg")), ".jpg should be accepted");
        assertTrue(filter.accept(new File("image.jpeg")), ".jpeg should be accepted");
    }

    @Test
    void testAcceptsGif() {
        assertTrue(filter.accept(new File("animation.gif")), ".gif should be accepted");
    }

    @Test
    void testRejectsOtherExtensions() {
        assertFalse(filter.accept(new File("document.txt")), ".txt should be rejected");
        assertFalse(filter.accept(new File("archive.zip")), ".zip should be rejected");
    }
}