package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;


/**
 * Interface to listen to drawing movements.
 */
public interface DrawingListener {
    /**
     * Triggered when a drawing is released.
     *
     * @param drawing the released drawing
     */
    public void drawingReleased(Drawing drawing);

    /**
     * Triggered when a drawing was added.
     *
     * @param drawing the added drawing
     */
    public void drawingAdded(Drawing drawing);
}