package CH.ifa.draw.util;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;

import CH.ifa.draw.framework.Drawing;


/**
 * AutosaveSaver defines a simple interface for saving drawings in an autosave file.
 */
public interface AutosaveSaver {
    /**
     * Saves the file.
     * @param drawing the drawing to be saved
     * @param filename the filename to be saved
     * @param loc a point
     * @param size the size of the drawing
     * @throws IOException the exception thrown if an error occurred during reading/writing
     **/
    public void saveAutosaveFile(Drawing drawing, File filename, Point loc, Dimension size)
        throws IOException;
}