/*
 * @(#)ActionTool.java 5.1
 *
 */
package CH.ifa.draw.standard;

import java.awt.event.MouseEvent;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;


/**
 * A tool that performs an action when it is active and
 * the mouse is clicked.
 */
public abstract class ActionTool extends AbstractTool {
    /**
     * Adds a mediator for the participants of the
     * drawing editor.
     *
     * @param editor the mediator
     */
    public ActionTool(DrawingEditor editor) {
        super(editor);
    }

    /**
     * Add the touched figure to the selection an invoke action
     * @see #action
     */
    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        Figure target = drawing().findFigure(x, y);
        if (target != null) {
            view().addToSelection(target);
            action(target);
        }
    }

    /**
     * Informs the editor, that the tool is done.
     *
     * @param e the MouseEvent that was fired by a
     *          certain mouse interaction.
     * @param x the horizontal axis.
     * @param y the vertical axis.
     */
    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        editor().toolDone();
    }

    /**
     * Performs an action with the touched figure.
     */
    public abstract void action(Figure figure);
}