package CH.ifa.draw.io.importFormats;

import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.filechooser.FileFilter;

import CH.ifa.draw.framework.Drawing;


/**
 * This interface must be implemented to define new ImportFormats.
 */
public interface ImportFormat {

    /**
     * Converts an array of files into a list of drawings.
     * @require files != null.
     * @ensure result != null.
     * @throws Exception is caught by the ImportHolder.
     * @param paths array of paths to the files to be imported.
     * @return list of drawings.
     */
    public List<Drawing> importFiles(URL[] paths) throws Exception;

    /**
     * Returns the FileFilter for the ImportFormat.
     * @ensure result != null.
     * @return FileFilter the FileFilter for the ImportFormat.
     */
    public FileFilter fileFilter();

    /**
     * Returns a name for the ImportFormat e.g. PNML.
     * @ensure result != null.
     * @return String the Name of the ImportFormat.
     */
    public String formatName();

    /**
     * Checks if the file can be imported.
     * @param path path to the file to be checked.
     * @return boolean true: import possible; false: import NOT possible.
     */
    public boolean canImport(URL path);

    /**
     * Checks if the file can be imported.
     * @param path URI to be checked.
     * @return boolean true: import possible; false: import NOT possible.
     */
    public boolean canImport(URI path);
}