package CH.ifa.draw.io;

import java.awt.Dimension;
import java.awt.Point;

import CH.ifa.draw.framework.Drawing;

/**
 * PositionedDrawing is a composition of a {@link Drawing}, a {@link Point} and a {@link Dimension}.
 * It thus provides a drawing with a position and a size as attributes.
 */
public class PositionedDrawing {
    private Point windowLoc;
    private Dimension windowDim;
    private Drawing drawing;

    /**
     * Constructs a PositionedDrawing out of a given point, a given Dimension and a given drawing.
     * @param windowLocation The given position
     * @param windowDim The given dimension
     * @param drawing The given drawing
     */
    public PositionedDrawing(Point windowLocation, Dimension windowDim, Drawing drawing) {
        this.windowLoc = windowLocation;
        this.windowDim = windowDim;
        this.drawing = drawing;
    }

    /**
     * Returns the Location as a dimensional point in window.
     *
     * @return The Location
     */
    public Point getWindowLocation() {
        return windowLoc;
    }

    /**
     * Returns the dimension in window.
     *
     * @return The dimension
     */
    public Dimension getWindowDimension() {
        return windowDim;
    }

    /**
     * Returns the drawing that is positioned in window.
     *
     * @return The drawing
     */
    public Drawing getDrawing() {
        return drawing;
    }
}