package CH.ifa.draw.gui.settingswindow;

import java.awt.BorderLayout;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

import CH.ifa.draw.gui.reactivecomponents.Component;
import de.renew.plugin.propertymanagement.ConfigurableProperty;


/**
 * The body of the settings window.
 */
public class BodyComponent extends Component {

    private final Map<String, ConfigurableProperty> _properties;

    private final Runnable _savePropertiesGlobalAction;

    private final Runnable _savePropertiesLocalAction;

    /**
     * Constructor for the Body Component. It takes the properties to display and the actions to save the properties.
     *
     * @param properties                 The properties to display.
     * @param savePropertiesGlobalAction The action to save the properties globally.
     * @param savePropertiesLocalAction  The action to save the properties locally.
     */
    public BodyComponent(
        Map<String, ConfigurableProperty> properties, Runnable savePropertiesGlobalAction,
        Runnable savePropertiesLocalAction)
    {
        _properties = properties;
        _savePropertiesGlobalAction = savePropertiesGlobalAction;
        _savePropertiesLocalAction = savePropertiesLocalAction;
    }

    @Override
    protected JComponent render() {
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());

        renderContentIn(body);
        renderFooterIn(body);

        return body;
    }

    private void renderContentIn(JPanel parentContainer) {
        Component content = new ContentComponent(_properties);
        parentContainer.add(content.get(), BorderLayout.CENTER);
    }

    private void renderFooterIn(JPanel parentContainer) {
        Component footer =
            new FooterComponent(_savePropertiesGlobalAction, _savePropertiesLocalAction);
        parentContainer.add(footer.get(), BorderLayout.PAGE_END);
    }
}