/*
 * Created on Apr 18, 2003
 */

package CH.ifa.draw.framework;

import java.util.HashSet;

import CH.ifa.draw.io.SimpleFileFilter;


/**
 * This class holds the SimpleFileFilters for a Drawing.
 * It will provide the default SimpleFileFilters.
 *
 * @author Lawrence Cabac
 */
public class FilterContainer {
    private final SimpleFileFilter _defaultFileFilter;
    private final HashSet<SimpleFileFilter> _importfileFilters;
    private final HashSet<SimpleFileFilter> _exportfileFilters;

    /**
     * Initializes empty sets for import and export file filters, and sets the provided filter
     * as the default.
     * @param ff default file filter
     */
    public FilterContainer(SimpleFileFilter ff) {
        _importfileFilters = new HashSet<>();
        _exportfileFilters = new HashSet<>();
        _defaultFileFilter = ff;

    }

    /**
     * Registers new Import file filters.
     * @param ff file filter to be added
     * @return boolean, {@code true} if successfully added
     */
    public boolean registerImportFileFilter(SimpleFileFilter ff) {
        return _importfileFilters.add(ff);
    }

    /**
     * Registers new Export file filters.
     * @param ff file filter to be added
     * @return boolean, {@code true} if successfully added
     */
    public boolean registerExportFileFilter(SimpleFileFilter ff) {
        return _exportfileFilters.add(ff);
    }

    /**
     * Deregisters Import File Filter.
     * @param ff file filter to be removed
     * @return boolean, {@code true} if successfully removed.
     */
    public boolean deregisterImportFileFilter(SimpleFileFilter ff) {
        return _importfileFilters.remove(ff);
    }

    /* (non-Javadoc)
     * @see de.renew.diagram.drawing.FilterContainer#getFileFilter()
     */

    /**
     * Gets the import file filters.
     * @return import file filters
     */
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return _importfileFilters;
    }

    /* (non-Javadoc)
     * @see de.renew.diagram.drawing.FilterContainer#getFileFilter()
     */

    /**
     * Gets the export file filters.
     * @return export file filters
     */
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return _exportfileFilters;
    }

    /* (non-Javadoc)
    * @see de.renew.diagram.drawing.FilterContainer#getDefaultFileFilter()
    */

    /**
     * Gets the default Filter.
     * @return default filter
     */
    public SimpleFileFilter getDefaultFileFilter() {
        return _defaultFileFilter;
    }
}