/*
 * @(#)FigureChangeListener.java 5.1
 *
 */

package CH.ifa.draw.framework;

import java.util.EventListener;


/**
 * Listener interested in Figure changes.
 *
 */
public interface FigureChangeListener extends EventListener {

    /**
     * Sent when an area is invalid.
     * @param e event triggered by figure change
     */
    void figureInvalidated(FigureChangeEvent e);

    /**
     * Sent when a figure changed.
     * @param e event triggered by figure change
     */
    void figureChanged(FigureChangeEvent e);

    /**
     * Sent when a figure was removed.
     * @param e event triggered by figure change
     */
    void figureRemoved(FigureChangeEvent e);

    /**
     * Sent when requesting to remove a figure.
     * @param e event triggered by figure change
     */
    void figureRequestRemove(FigureChangeEvent e);

    /**
     * Sent when an update should happen.
     * @param e event triggered by figure change
     */
    void figureRequestUpdate(FigureChangeEvent e);

    /**
     * Sent when the figure changes its handles.
     * @param e event triggered by figure change
     */
    void figureHandlesChanged(FigureChangeEvent e);
}