/*
 * @(#)RectangleFigure.java 5.1
 *
 */
package CH.ifa.draw.figures;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Vector;

import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

/**
 * A rectangle figure.
 */
public class RectangleFigure extends AttributeFigure {
    /*
     * Serialization support.
     */
    private static final long serialVersionUID = 184722075881789163L;

    /**
     * Determines position and size of the rectangle by
     * specifying position and size of its bounding box.
     *
     * @serial
     **/
    private Rectangle fDisplayBox;

    /**
     * Unused serial version number.
     */
    @SuppressWarnings("unused")
    private int rectangleFigureSerializedDataVersion = 1;

    /**
     * Constructor of the class to create an instance of a RectangleFigure with the
     * origin and corner  at (0, 0).
     */
    public RectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    /**
     * Constructor to create an instance and specify a point of origin and a corner.
     *
     * @param origin point of origin of the RectangleFigure
     * @param corner point of the corner of the RectangleFigure
     */
    public RectangleFigure(Point origin, Point corner) {
        basicDisplayBox(origin, corner);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        fDisplayBox = new Rectangle(origin);
        fDisplayBox.add(corner);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(fDisplayBox.x, fDisplayBox.y, fDisplayBox.width, fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        fDisplayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = displayBox();
        Graphics2D g2 = (Graphics2D) g;
        Shape s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = displayBox();
        Graphics2D g2 = (Graphics2D) g;
        Shape s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    //-- store / load ----------------------------------------------
    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(fDisplayBox.x);
        dw.writeInt(fDisplayBox.y);
        dw.writeInt(fDisplayBox.width);
        dw.writeInt(fDisplayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}