package CH.ifa.draw.application;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JFrame;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;


/**
 * View container for a drawing.
 */
public interface DrawingViewContainer {

    /**
     * Returns the location of the drawing view controller
     * @return the location of the drawing view container.
     */
    public Point getLocation();

    /**
     * Returns the size of the drawing view container.
     * @return the size of the drawing view container.
     */
    public Dimension getSize();

    /**
     * Function called when the drawing view container releases the discard.
     */
    public void onDiscardRelease();

    /**
     * Returns the view of the drawing view container.
     * @return the view of the drawing view container.
     */
    public DrawingView view();

    /**
     * validates the drawing view container.
     */
    public void validate();

    /**
     * Sets the title of the drawing view container to the name of the given drawing.
     * @param drawing the drawing which name should be used as title of the drawing view container.
     */
    public void setTitle(Drawing drawing);

    /**
     * Sets the title to the given String.
     * @param title new title of the drawing view container.
     */
    public void setTitle(String title);

    /**
     * Shows the drawing view container.
     * @param b is the drawing window visible true/false.
     */
    public void setVisible(boolean b);

    /**
     * Requests the focus.
     */
    public void requestFocus();

    /**
     * Sets the state to the new value.
     * @param state the new state.
     */
    public void setState(int state);

    /**
     * Returns the main frame of the drawing view container.
     * @return the frame of the drawing view container.
     */
    public JFrame getFrame();

    /**
     * Discards the drawing view container.
     */
    public void discard();
}