package de.renew.remote.cryptix;

import cryptix.provider.*;
import cryptix.provider.cipher.*;
import cryptix.provider.key.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;
import xjava.security.*;


public class DESOutputStream extends FilterOutputStream
{
	private OutputStream out;
	private DES encrypter;

	private byte[] buffer;
	private int builtBytes;

	public DESOutputStream(OutputStream out, byte[] key)
		throws Exception
	{
		super(out);
		this.out = out;
		encrypter = (DES) Cipher.getInstance("DES/ECB/NONE", "Cryptix");
		encrypter.initEncrypt(new RawSecretKey("DES", key));
		buffer = new byte[32];
		builtBytes = 0;
	}

	public void close()
		throws IOException
	{
		writeBuffer();
		super.close();
	}

	public void flush()
		throws IOException
	{
		writeBuffer();
		super.flush();
	}

	public void write(int aByte)
		throws IOException
	{
		buffer[builtBytes++] = (byte) (aByte & 0xFF);

		if (builtBytes >= 32)
		{
			writeBuffer();
		}
	}

	public void write(byte bytes[], int offset, int length)
		throws IOException
	{
		while (length + builtBytes > 32)
		{
			int copyBytes = 32 - builtBytes;
			System.arraycopy(bytes, offset, buffer, builtBytes, copyBytes);
			offset += copyBytes;
			length -= copyBytes;
			builtBytes += copyBytes;

			writeBuffer();
		}

		if (length > 0)
		{
			System.arraycopy(bytes, offset, buffer, builtBytes, length);
			builtBytes += length;
		}

		if (builtBytes >= 32)
		{
			writeBuffer();
		}
	}

	private void writeBuffer()
		throws IOException
	{
		if (builtBytes <= 0)
		{
			return;
		}

		byte[] encrypted = encrypter.crypt(buffer);

		out.write(builtBytes);
		out.write(encrypted, 0, 32);
		builtBytes = 0;
	}
}
